<?xml version="1.0" ?>
<template expand_clusters="true" version="2">
    <!-- Updated on 2025-11-13T18:03:25.599151545 using eu-gerrit-1.euhpc.arm.com:29418/dsg/streamline - origin/changes/83/830983/1 (128f11507b5b58b15280689d64925b5636464515) - "Split out top down timeline charts where there are different divisors" -->
    <supported-cpuid id="Cortex-A76" />
    <chart average_cores="yes" average_selection="yes" height="61" percentage="yes" rendering_type="bar" series_composition="stacked" title="CPU Activity">
        <series color="58,223,67" description="User activity" display="AVERAGE" expression="$CPUActivityUser" name="User activity"/>
        <series color="223,71,66" description="System activity" display="AVERAGE" expression="$CPUActivitySystem" name="System activity"/>
    </chart>   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Instructions per Cycle (Cortex-A76)">
        <series color="255,153,0" description="This metric measures the number of instructions retired per cycle" expression="if(($InstructionsPerCycleCortexA76CPU_CYCLES &gt; 0), ($InstructionsPerCycleCortexA76INST_RETIRED / $InstructionsPerCycleCortexA76CPU_CYCLES), 0)" name="Instructions Per Cycle" units="instructions"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Cycle Accounting (Cortex-A76)">
        <series color="255,153,0" description="This metric is the percentage of cycles that were stalled due to resource constraints in the frontend unit of the processor" expression="if(($FrontendStalledCyclesCortexA76CPU_CYCLES &gt; 0), min(($FrontendStalledCyclesCortexA76STALL_FRONTEND / $FrontendStalledCyclesCortexA76CPU_CYCLES), 1), 0)" name="Frontend Stalled Cycles" units="percent"/>
        <series color="0,102,255" description="This metric is the percentage of cycles that were stalled due to resource constraints in the backend unit of the processor" expression="if(($BackendStalledCyclesCortexA76CPU_CYCLES &gt; 0), min(($BackendStalledCyclesCortexA76STALL_BACKEND / $BackendStalledCyclesCortexA76CPU_CYCLES), 1), 0)" name="Backend Stalled Cycles" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="General (Cortex-A76)">
        <series color="255,153,0" description="This metric measures the percentage of instructions speculatively executed that are subsequently retired" expression="if(($RetiredInstructionsPercentageCortexA76INST_SPEC &gt; 0), min(($RetiredInstructionsPercentageCortexA76INST_RETIRED / $RetiredInstructionsPercentageCortexA76INST_SPEC), 1), 0)" name="Retired Instructions Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Branch Effectiveness (Frontend Stalled Cycles) (Cortex-A76)">
        <series color="255,153,0" description="This metric measures the number of branch mispredictions per thousand instructions executed" expression="if(($BranchMPKICortexA76INST_RETIRED &gt; 0), (($BranchMPKICortexA76BR_MIS_PRED_RETIRED / $BranchMPKICortexA76INST_RETIRED) * 1000), 0)" name="Branch MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Branch Effectiveness (Frontend Stalled Cycles) (Cortex-A76)">
        <series color="255,153,0" description="This metric measures the ratio of branches mispredicted to the total number of branches architecturally executed. This gives an indication of the effectiveness of the branch prediction unit." expression="if(($BranchMispredictionPercentageCortexA76BR_RETIRED &gt; 0), min(($BranchMispredictionPercentageCortexA76BR_MIS_PRED_RETIRED / $BranchMispredictionPercentageCortexA76BR_RETIRED), 1), 0)" name="Branch Misprediction Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Instruction TLB Effectiveness (Frontend Stalled Cycles) (Cortex-A76)">
        <series color="255,153,0" description="This metric measures the number of instruction TLB Walks per thousand instructions executed" expression="if(($ITLBMPKICortexA76INST_RETIRED &gt; 0), (($ITLBMPKICortexA76ITLB_WALK / $ITLBMPKICortexA76INST_RETIRED) * 1000), 0)" name="ITLB MPKI" units="misses"/>
        <series color="0,102,255" description="This metric measures the number of level 1 instruction TLB accesses missed per thousand instructions executed" expression="if(($L1InstructionTLBMPKICortexA76INST_RETIRED &gt; 0), (($L1InstructionTLBMPKICortexA76L1I_TLB_REFILL / $L1InstructionTLBMPKICortexA76INST_RETIRED) * 1000), 0)" name="L1 Instruction TLB MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Instruction TLB Effectiveness (Frontend Stalled Cycles) (Cortex-A76)">
        <series color="255,153,0" description="This metric measures the ratio of instruction TLB Walks to the total number of instruction TLB accesses. This gives an indication of the effectiveness of the instruction TLB accesses." expression="if(($ITLBWalkPercentageCortexA76L1I_TLB &gt; 0), min(($ITLBWalkPercentageCortexA76ITLB_WALK / $ITLBWalkPercentageCortexA76L1I_TLB), 1), 0)" name="ITLB Walk Percentage" units="percent"/>
        <series color="0,102,255" description="This metric measures the ratio of level 1 instruction TLB accesses missed to the total number of level 1 instruction TLB accesses. This gives an indication of the effectiveness of the level 1 instruction TLB." expression="if(($L1InstructionTLBMissPercentageCortexA76L1I_TLB &gt; 0), min(($L1InstructionTLBMissPercentageCortexA76L1I_TLB_REFILL / $L1InstructionTLBMissPercentageCortexA76L1I_TLB), 1), 0)" name="L1 Instruction TLB Miss Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L1 Instruction Cache Effectiveness (Frontend Stalled Cycles) (Cortex-A76)">
        <series color="255,153,0" description="This metric measures the number of level 1 instruction cache accesses missed per thousand instructions executed" expression="if(($L1ICacheMPKICortexA76INST_RETIRED &gt; 0), (($L1ICacheMPKICortexA76L1I_CACHE_REFILL / $L1ICacheMPKICortexA76INST_RETIRED) * 1000), 0)" name="L1I Cache MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L1 Instruction Cache Effectiveness (Frontend Stalled Cycles) (Cortex-A76)">
        <series color="255,153,0" description="This metric measures the ratio of level 1 instruction cache accesses missed to the total number of level 1 instruction cache accesses. This gives an indication of the effectiveness of the level 1 instruction cache." expression="if(($L1ICacheMissPercentageCortexA76L1I_CACHE &gt; 0), min(($L1ICacheMissPercentageCortexA76L1I_CACHE_REFILL / $L1ICacheMissPercentageCortexA76L1I_CACHE), 1), 0)" name="L1I Cache Miss Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Data TLB Effectiveness (Backend Stalled Cycles) (Cortex-A76)">
        <series color="255,153,0" description="This metric measures the number of data TLB Walks per thousand instructions executed" expression="if(($DTLBMPKICortexA76INST_RETIRED &gt; 0), (($DTLBMPKICortexA76DTLB_WALK / $DTLBMPKICortexA76INST_RETIRED) * 1000), 0)" name="DTLB MPKI" units="misses"/>
        <series color="153,0,255" description="This metric measures the number of level 1 data TLB accesses missed per thousand instructions executed" expression="if(($L1DataTLBMPKICortexA76INST_RETIRED &gt; 0), (($L1DataTLBMPKICortexA76L1D_TLB_REFILL / $L1DataTLBMPKICortexA76INST_RETIRED) * 1000), 0)" name="L1 Data TLB MPKI" units="misses"/>
        <series color="0,255,153" description="This metric measures the number of level 2 unified TLB accesses missed per thousand instructions executed" expression="if(($L2UnifiedTLBMPKICortexA76INST_RETIRED &gt; 0), (($L2UnifiedTLBMPKICortexA76L2D_TLB_REFILL / $L2UnifiedTLBMPKICortexA76INST_RETIRED) * 1000), 0)" name="L2 Unified TLB MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Data TLB Effectiveness (Backend Stalled Cycles) (Cortex-A76)">
        <series color="255,153,0" description="This metric measures the ratio of data TLB Walks to the total number of data TLB accesses. This gives an indication of the effectiveness of the data TLB accesses." expression="if(($DTLBWalkPercentageCortexA76L1D_TLB &gt; 0), min(($DTLBWalkPercentageCortexA76DTLB_WALK / $DTLBWalkPercentageCortexA76L1D_TLB), 1), 0)" name="DTLB Walk Percentage" units="percent"/>
        <series color="153,0,255" description="This metric measures the ratio of level 1 data TLB accesses missed to the total number of level 1 data TLB accesses. This gives an indication of the effectiveness of the level 1 data TLB." expression="if(($L1DataTLBMissPercentageCortexA76L1D_TLB &gt; 0), min(($L1DataTLBMissPercentageCortexA76L1D_TLB_REFILL / $L1DataTLBMissPercentageCortexA76L1D_TLB), 1), 0)" name="L1 Data TLB Miss Percentage" units="percent"/>
        <series color="0,255,153" description="This metric measures the ratio of level 2 unified TLB accesses missed to the total number of level 2 unified TLB accesses. This gives an indication of the effectiveness of the level 2 TLB." expression="if(($L2UnifiedTLBMissPercentageCortexA76L2D_TLB &gt; 0), min(($L2UnifiedTLBMissPercentageCortexA76L2D_TLB_REFILL / $L2UnifiedTLBMissPercentageCortexA76L2D_TLB), 1), 0)" name="L2 Unified TLB Miss Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L1 Data Cache Effectiveness (Backend Stalled Cycles) (Cortex-A76)">
        <series color="255,153,0" description="This metric measures the number of level 1 data cache accesses missed per thousand instructions executed" expression="if(($L1DCacheMPKICortexA76INST_RETIRED &gt; 0), (($L1DCacheMPKICortexA76L1D_CACHE_REFILL / $L1DCacheMPKICortexA76INST_RETIRED) * 1000), 0)" name="L1D Cache MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L1 Data Cache Effectiveness (Backend Stalled Cycles) (Cortex-A76)">
        <series color="255,153,0" description="This metric measures the ratio of level 1 data cache accesses missed to the total number of level 1 data cache accesses. This gives an indication of the effectiveness of the level 1 data cache." expression="if(($L1DCacheMissPercentageCortexA76L1D_CACHE &gt; 0), min(($L1DCacheMissPercentageCortexA76L1D_CACHE_REFILL / $L1DCacheMissPercentageCortexA76L1D_CACHE), 1), 0)" name="L1D Cache Miss Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L2 Unified Cache Effectiveness (Backend Stalled Cycles) (Cortex-A76)">
        <series color="255,153,0" description="This metric measures the number of level 2 unified cache accesses missed per thousand instructions executed. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L2CacheMPKICortexA76INST_RETIRED &gt; 0), (($L2CacheMPKICortexA76L2D_CACHE_REFILL / $L2CacheMPKICortexA76INST_RETIRED) * 1000), 0)" name="L2 Cache MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L2 Unified Cache Effectiveness (Backend Stalled Cycles) (Cortex-A76)">
        <series color="255,153,0" description="This metric measures the ratio of level 2 cache accesses missed to the total number of level 2 cache accesses. This gives an indication of the effectiveness of the level 2 cache, which is a unified cache that stores both data and instruction. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L2CacheMissPercentageCortexA76L2D_CACHE &gt; 0), min(($L2CacheMissPercentageCortexA76L2D_CACHE_REFILL / $L2CacheMissPercentageCortexA76L2D_CACHE), 1), 0)" name="L2 Cache Miss Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L3 Unified Cache Effectiveness (Backend Stalled Cycles) (Cortex-A76)">
        <series color="255,153,0" description="This metric measures the number of level 3 unified cache accesses missed per thousand instructions executed. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L3CacheMPKICortexA76INST_RETIRED &gt; 0), (($L3CacheMPKICortexA76L3D_CACHE_REFILL / $L3CacheMPKICortexA76INST_RETIRED) * 1000), 0)" name="L3 Cache MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L3 Unified Cache Effectiveness (Backend Stalled Cycles) (Cortex-A76)">
        <series color="255,153,0" description="This metric measures the ratio of level 3 cache accesses missed to the total number of level 3 cache accesses. This gives an indication of the effectiveness of the level 3 cache, which is a unified cache that stores both data and instruction. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L3CacheMissPercentageCortexA76L3D_CACHE &gt; 0), min(($L3CacheMissPercentageCortexA76L3D_CACHE_REFILL / $L3CacheMissPercentageCortexA76L3D_CACHE), 1), 0)" name="L3 Cache Miss Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Last Level Cache Effectiveness (Backend Stalled Cycles) (Cortex-A76)">
        <series color="255,153,0" description="This metric measures the number of last level cache read accesses missed per thousand instructions executed" expression="if(($LLCacheReadMPKICortexA76INST_RETIRED &gt; 0), (($LLCacheReadMPKICortexA76LL_CACHE_MISS_RD / $LLCacheReadMPKICortexA76INST_RETIRED) * 1000), 0)" name="LL Cache Read MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Last Level Cache Effectiveness (Backend Stalled Cycles) (Cortex-A76)">
        <series color="255,153,0" description="This metric measures the ratio of last level cache read accesses missed to the total number of last level cache accesses. This gives an indication of the effectiveness of the last level cache for read traffic. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a system level cache." expression="if(($LLCacheReadMissPercentageCortexA76LL_CACHE_RD &gt; 0), min(($LLCacheReadMissPercentageCortexA76LL_CACHE_MISS_RD / $LLCacheReadMissPercentageCortexA76LL_CACHE_RD), 1), 0)" name="LL Cache Read Miss Percentage" units="percent"/>
        <series color="0,102,255" description="This metric measures the ratio of last level cache read accesses hit in the cache to the total number of last level cache accesses. This gives an indication of the effectiveness of the last level cache for read traffic. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a system level cache." expression="if(($LLCacheReadHitPercentageCortexA76LL_CACHE_RD &gt; 0), min((($LLCacheReadHitPercentageCortexA76LL_CACHE_RD - $LLCacheReadHitPercentageCortexA76LL_CACHE_MISS_RD) / $LLCacheReadHitPercentageCortexA76LL_CACHE_RD), 1), 0)" name="LL Cache Read Hit Percentage" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Speculative Operation Mix (Retired Instructions Percentage) (Cortex-A76)">
        <series color="255,153,0" description="This metric measures instruction and data barrier operations as a percentage of operations speculatively executed" expression="if(($BarrierOperationsPercentageCortexA76INST_SPEC &gt; 0), min(((($BarrierOperationsPercentageCortexA76ISB_SPEC + $BarrierOperationsPercentageCortexA76DSB_SPEC) + $BarrierOperationsPercentageCortexA76DMB_SPEC) / $BarrierOperationsPercentageCortexA76INST_SPEC), 1), 0)" name="Barrier Operations Percentage" units="percent"/>
        <series color="255,0,102" description="This metric measures branch operations as a percentage of operations speculatively executed" expression="if(($BranchOperationsPercentageCortexA76INST_SPEC &gt; 0), min((($BranchOperationsPercentageCortexA76BR_IMMED_SPEC + $BranchOperationsPercentageCortexA76BR_INDIRECT_SPEC) / $BranchOperationsPercentageCortexA76INST_SPEC), 1), 0)" name="Branch Operations Percentage" units="percent"/>
        <series color="153,0,255" description="This metric measures crypto operations as a percentage of operations speculatively executed" expression="if(($CryptoOperationsPercentageCortexA76INST_SPEC &gt; 0), min(($CryptoOperationsPercentageCortexA76CRYPTO_SPEC / $CryptoOperationsPercentageCortexA76INST_SPEC), 1), 0)" name="Crypto Operations Percentage" units="percent"/>
        <series color="0,102,255" description="This metric measures scalar integer operations as a percentage of operations speculatively executed" expression="if(($IntegerOperationsPercentageCortexA76INST_SPEC &gt; 0), min((($IntegerOperationsPercentageCortexA76DP_SPEC - $IntegerOperationsPercentageCortexA76DSB_SPEC) / $IntegerOperationsPercentageCortexA76INST_SPEC), 1), 0)" name="Integer Operations Percentage" units="percent"/>
        <series color="0,255,153" description="This metric measures load and store operations as a percentage of operations speculatively executed" expression="if(($LoadStoreOperationsPercentageCortexA76INST_SPEC &gt; 0), min(($LoadStoreOperationsPercentageCortexA76LDST_SPEC / $LoadStoreOperationsPercentageCortexA76INST_SPEC), 1), 0)" name="Load/Store Operations Percentage" units="percent"/>
        <series color="102,255,0" description="This metric measures scalar floating point operations as a percentage of operations speculatively executed" expression="if(($FloatingPointOperationsPercentageCortexA76INST_SPEC &gt; 0), min(($FloatingPointOperationsPercentageCortexA76VFP_SPEC / $FloatingPointOperationsPercentageCortexA76INST_SPEC), 1), 0)" name="Floating Point Operations Percentage" units="percent"/>
        <series color="128,77,0" description="This metric measures advanced SIMD operations as a percentage of total operations speculatively executed" expression="if(($AdvancedSIMDOperationsPercentageCortexA76INST_SPEC &gt; 0), min(($AdvancedSIMDOperationsPercentageCortexA76ASE_SPEC / $AdvancedSIMDOperationsPercentageCortexA76INST_SPEC), 1), 0)" name="Advanced SIMD Operations Percentage" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Speculative Operation Mix (Retired Instructions Percentage) (Cortex-A76)">
        <series color="255,153,0" description="This metric measures load-exclusive instructions as a percentage of instructions speculatively executed" expression="if(($LoadExclusiveInstructionsPercentageCortexA76INST_SPEC &gt; 0), min(($LoadExclusiveInstructionsPercentageCortexA76LDREX_SPEC / $LoadExclusiveInstructionsPercentageCortexA76INST_SPEC), 1), 0)" name="Load-Exclusive Instructions Percentage" units="percent"/>
        <series color="0,102,255" description="This metric measures store-exclusive instructions as a percentage of instructions speculatively executed" expression="if(($StoreExclusiveInstructionsPercentageCortexA76INST_SPEC &gt; 0), min(($StoreExclusiveInstructionsPercentageCortexA76STREX_SPEC / $StoreExclusiveInstructionsPercentageCortexA76INST_SPEC), 1), 0)" name="Store-Exclusive Instructions Percentage" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Speculative Operation Mix (Retired Instructions Percentage) (Cortex-A76)">
        <series color="255,153,0" description="This metric measures load operations as a percentage of load and store operations speculatively executed" expression="if(($LoadAsLoadStoreOperationsPercentageCortexA76LDST_SPEC &gt; 0), min(($LoadAsLoadStoreOperationsPercentageCortexA76LD_SPEC / $LoadAsLoadStoreOperationsPercentageCortexA76LDST_SPEC), 1), 0)" name="Load as Load/Store Operations Percentage" units="percent"/>
        <series color="0,102,255" description="This metric measures store operations as a percentage of load and store operations speculatively executed" expression="if(($StoreAsLoadStoreOperationsPercentageCortexA76LDST_SPEC &gt; 0), min(($StoreAsLoadStoreOperationsPercentageCortexA76ST_SPEC / $StoreAsLoadStoreOperationsPercentageCortexA76LDST_SPEC), 1), 0)" name="Store as Load/Store Operations Percentage" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Speculative Operation Mix (Retired Instructions Percentage) (Cortex-A76)">
        <series color="255,153,0" description="This metric measures load operations as a percentage of operations speculatively executed" expression="if(($LoadOperationsPercentageCortexA76INST_SPEC &gt; 0), min(($LoadOperationsPercentageCortexA76LD_SPEC / $LoadOperationsPercentageCortexA76INST_SPEC), 1), 0)" name="Load Operations Percentage" units="percent"/>
        <series color="0,102,255" description="This metric measures store operations as a percentage of operations speculatively executed" expression="if(($StoreOperationsPercentageCortexA76INST_SPEC &gt; 0), min(($StoreOperationsPercentageCortexA76ST_SPEC / $StoreOperationsPercentageCortexA76INST_SPEC), 1), 0)" name="Store Operations Percentage" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Speculative Operation Mix (Retired Instructions Percentage) (Cortex-A76)">
        <series color="255,153,0" description="This metric measures memory-read instructions with acquire or acquirepc semantics as a percentage of instructions speculatively executed" expression="if(($LoadAcquireInstructionsPercentageCortexA76INST_SPEC &gt; 0), min(($LoadAcquireInstructionsPercentageCortexA76RC_LD_SPEC / $LoadAcquireInstructionsPercentageCortexA76INST_SPEC), 1), 0)" name="Load-Acquire Instructions Percentage" units="percent"/>
        <series color="0,102,255" description="This metric measures memory-write instructions with release semantics as a percentage of instructions speculatively executed" expression="if(($StoreReleaseInstructionsPercentageCortexA76INST_SPEC &gt; 0), min(($StoreReleaseInstructionsPercentageCortexA76RC_ST_SPEC / $StoreReleaseInstructionsPercentageCortexA76INST_SPEC), 1), 0)" name="Store-Release Instructions Percentage" units="percent"/>
   </chart>
    <select-metric id="ARMv8_Cortex_A76_metric_backend_stalled_cycles" />
    <select-metric id="ARMv8_Cortex_A76_metric_barrier_percentage" />
    <select-metric id="ARMv8_Cortex_A76_metric_branch_misprediction_ratio" />
    <select-metric id="ARMv8_Cortex_A76_metric_branch_mpki" />
    <select-metric id="ARMv8_Cortex_A76_metric_branch_percentage" />
    <select-metric id="ARMv8_Cortex_A76_metric_crypto_percentage" />
    <select-metric id="ARMv8_Cortex_A76_metric_dtlb_mpki" />
    <select-metric id="ARMv8_Cortex_A76_metric_dtlb_walk_ratio" />
    <select-metric id="ARMv8_Cortex_A76_metric_frontend_stalled_cycles" />
    <select-metric id="ARMv8_Cortex_A76_metric_integer_dp_percentage" />
    <select-metric id="ARMv8_Cortex_A76_metric_ipc" />
    <select-metric id="ARMv8_Cortex_A76_metric_itlb_mpki" />
    <select-metric id="ARMv8_Cortex_A76_metric_itlb_walk_ratio" />
    <select-metric id="ARMv8_Cortex_A76_metric_l1d_cache_miss_ratio" />
    <select-metric id="ARMv8_Cortex_A76_metric_l1d_cache_mpki" />
    <select-metric id="ARMv8_Cortex_A76_metric_l1d_tlb_miss_ratio" />
    <select-metric id="ARMv8_Cortex_A76_metric_l1d_tlb_mpki" />
    <select-metric id="ARMv8_Cortex_A76_metric_l1i_cache_miss_ratio" />
    <select-metric id="ARMv8_Cortex_A76_metric_l1i_cache_mpki" />
    <select-metric id="ARMv8_Cortex_A76_metric_l1i_tlb_miss_ratio" />
    <select-metric id="ARMv8_Cortex_A76_metric_l1i_tlb_mpki" />
    <select-metric id="ARMv8_Cortex_A76_metric_l2_cache_miss_ratio" />
    <select-metric id="ARMv8_Cortex_A76_metric_l2_cache_mpki" />
    <select-metric id="ARMv8_Cortex_A76_metric_l2_tlb_miss_ratio" />
    <select-metric id="ARMv8_Cortex_A76_metric_l2_tlb_mpki" />
    <select-metric id="ARMv8_Cortex_A76_metric_l3_cache_miss_ratio" />
    <select-metric id="ARMv8_Cortex_A76_metric_l3_cache_mpki" />
    <select-metric id="ARMv8_Cortex_A76_metric_ldrex_percentage" />
    <select-metric id="ARMv8_Cortex_A76_metric_ll_cache_read_hit_ratio" />
    <select-metric id="ARMv8_Cortex_A76_metric_ll_cache_read_miss_ratio" />
    <select-metric id="ARMv8_Cortex_A76_metric_ll_cache_read_mpki" />
    <select-metric id="ARMv8_Cortex_A76_metric_load_ls_percentage" />
    <select-metric id="ARMv8_Cortex_A76_metric_load_percentage" />
    <select-metric id="ARMv8_Cortex_A76_metric_load_store_percentage" />
    <select-metric id="ARMv8_Cortex_A76_metric_rc_ld_percentage" />
    <select-metric id="ARMv8_Cortex_A76_metric_rc_st_percentage" />
    <select-metric id="ARMv8_Cortex_A76_metric_retired_insns_percent" />
    <select-metric id="ARMv8_Cortex_A76_metric_scalar_fp_percentage" />
    <select-metric id="ARMv8_Cortex_A76_metric_simd_percentage" />
    <select-metric id="ARMv8_Cortex_A76_metric_store_ls_percentage" />
    <select-metric id="ARMv8_Cortex_A76_metric_store_percentage" />
    <select-metric id="ARMv8_Cortex_A76_metric_strex_percentage" />
</template>
